//-----------------------------------------------------------------------------
// File: points on sphere.cpp
//
// Desc: DirectX MFC dialog application created by the DirectX AppWizard
//-----------------------------------------------------------------------------
#define STRICT
#define DIRECTINPUT_VERSION 0x0800
#include "stdafx.h"
#include <stdio.h>
#include "points on sphere.h"



//-----------------------------------------------------------------------------
// Application globals
//-----------------------------------------------------------------------------
TCHAR*          g_strAppTitle       = _T( "points on sphere" );
CApp            g_App;
HINSTANCE       g_hInst = NULL;
CAppForm*       g_AppFormView = NULL;




//-----------------------------------------------------------------------------
// The MFC macros are all listed here
//-----------------------------------------------------------------------------
IMPLEMENT_DYNCREATE( CAppDoc,      CDocument )
IMPLEMENT_DYNCREATE( CAppFrameWnd, CFrameWnd )
IMPLEMENT_DYNCREATE( CAppForm,     CFormView )




BEGIN_MESSAGE_MAP( CApp, CWinApp )
    //{{AFX_MSG_MAP(CApp)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()




BEGIN_MESSAGE_MAP( CAppForm, CFormView )
    //{{AFX_MSG_MAP(CAppForm)
    ON_COMMAND(    IDC_VIEWFULLSCREEN, OnToggleFullScreen )
    ON_BN_CLICKED(IDC_CHANGEDEVICE, OnChangeDevice)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_BUTTON4, OnButton4)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	ON_BN_CLICKED(IDC_BUTTON6, OnButton6)
	ON_BN_CLICKED(IDC_BUTTON7, OnButton7)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BEGIN_MESSAGE_MAP(CAppDoc, CDocument)
    //{{AFX_MSG_MAP(CAppDoc)
            // NOTE - the ClassWizard will add and remove mapping macros here.
            //    DO NOT EDIT what you see in these blocks of generated code!
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()




BEGIN_MESSAGE_MAP(CAppFrameWnd, CFrameWnd)
    //{{AFX_MSG_MAP(CAppFrameWnd)
    ON_COMMAND(IDM_CHANGEDEVICE, OnChangeDevice)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




//-----------------------------------------------------------------------------
// Name: CAppForm()
// Desc: Constructor for the dialog resource form.  Paired with ~CAppForm()
//       Member variables should be initialized to a known state here.  
//       The application window has not yet been created and no Direct3D device 
//       has been created, so any initialization that depends on a window or 
//       Direct3D should be deferred to a later stage. 
//-----------------------------------------------------------------------------
CAppForm::CAppForm()
         :CFormView( IDD_FORMVIEW )
{
    //{{AFX_DATA_INIT(CAppForm)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT

    g_AppFormView          = this;
    m_hwndRenderWindow     = NULL;
    m_hwndRenderFullScreen = NULL;
    m_hWndTopLevelParent   = NULL;

    // Override some CD3DApplication defaults:
    m_dwCreationWidth           = 500;
    m_dwCreationHeight          = 375;
    m_strWindowTitle            = TEXT( "points on sphere" );
    m_d3dEnumeration.AppUsesDepthBuffer   = TRUE;
	m_bStartFullscreen			= false;
	m_bShowCursorWhenFullscreen	= false;

    // Create a D3D font using d3dfont.cpp
    m_pFont                     = new CD3DFont( _T("Arial"), 12, D3DFONT_BOLD );
    m_bLoadingApp               = TRUE;
    m_pVB                       = NULL;
    m_pVB2                      = NULL;
    m_pVB3                      = NULL;
    m_pDI                       = NULL;
    m_pKeyboard                 = NULL;

    ZeroMemory( &m_UserInput, sizeof(m_UserInput) );
    m_fWorldRotX                = 0.0f;
    m_fWorldRotY                = 0.0f;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::OneTimeSceneInit()
// Desc: Paired with FinalCleanup().
//       The window has been created and the IDirect3D9 interface has been
//       created, but the device has not been created yet.  Here you can
//       perform application-related initialization and cleanup that does
//       not depend on a device.
//-----------------------------------------------------------------------------
HRESULT CAppForm::OneTimeSceneInit()
{
    // TODO: perform one time initialization

    // Initialize DirectInput
    InitInput( m_hWndTopLevelParent );

    m_bLoadingApp = FALSE;

    return S_OK;
}









//-----------------------------------------------------------------------------
// Name: InitInput()
// Desc: Initialize DirectInput objects
//-----------------------------------------------------------------------------
HRESULT CAppForm::InitInput( HWND hWnd )
{
    HRESULT hr;

    // Create a IDirectInput8*
    if( FAILED( hr = DirectInput8Create( GetModuleHandle(NULL), DIRECTINPUT_VERSION, 
                                         IID_IDirectInput8, (VOID**)&m_pDI, NULL ) ) )
        return DXTRACE_ERR( "DirectInput8Create", hr );
    
    // Create a IDirectInputDevice8* for the keyboard
    if( FAILED( hr = m_pDI->CreateDevice( GUID_SysKeyboard, &m_pKeyboard, NULL ) ) )
        return DXTRACE_ERR( "CreateDevice", hr );
    
    // Set the keyboard data format
    if( FAILED( hr = m_pKeyboard->SetDataFormat( &c_dfDIKeyboard ) ) )
        return DXTRACE_ERR( "SetDataFormat", hr );
    
    // Set the cooperative level on the keyboard
    if( FAILED( hr = m_pKeyboard->SetCooperativeLevel( hWnd, 
                                            DISCL_NONEXCLUSIVE | 
                                            DISCL_FOREGROUND | 
                                            DISCL_NOWINKEY ) ) )
        return DXTRACE_ERR( "SetCooperativeLevel", hr );

    // Acquire the keyboard
    m_pKeyboard->Acquire();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: ConfirmDevice()
// Desc: Called during device initialization, this code checks the display device
//       for some minimum set of capabilities
//-----------------------------------------------------------------------------
HRESULT CAppForm::ConfirmDevice( D3DCAPS9* pCaps, DWORD dwBehavior,
                                          D3DFORMAT Format )
{
    UNREFERENCED_PARAMETER( pCaps );
    UNREFERENCED_PARAMETER( dwBehavior );
    UNREFERENCED_PARAMETER( Format );
    BOOL bCapsAcceptable;

    // TODO: Perform checks to see if these display caps are acceptable.
    bCapsAcceptable = TRUE;

    if( bCapsAcceptable )         
        return S_OK;
    else
        return E_FAIL;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::InitDeviceObjects()
// Desc: Paired with DeleteDeviceObjects()
//       The device has been created.  Resources that are not lost on
//       Reset() can be created here -- resources in D3DPOOL_MANAGED,
//       D3DPOOL_SCRATCH, or D3DPOOL_SYSTEMMEM.  Image surfaces created via
//       CreateImageSurface are never lost and can be created here.  Vertex
//       shaders and pixel shaders can also be created here as they are not
//       lost on Reset().
//-----------------------------------------------------------------------------

HRESULT CAppForm::oxe_RandomSpherePoints(LPDIRECT3DVERTEXBUFFER9& vb, int num, float r, int method, bool regular)
	{
    HRESULT hr;

    SAFE_RELEASE( vb );

    // Create the vertex buffer
    if( FAILED( hr = m_pd3dDevice->CreateVertexBuffer( num*sizeof(CUSTOMVERTEX),
                                                  0, D3DFVF_CUSTOMVERTEX,
                                                  D3DPOOL_MANAGED, &vb, NULL ) ) )
        return DXTRACE_ERR( "CreateVertexBuffer", hr );

    CUSTOMVERTEX* pVertices;

    if( FAILED( hr = vb->Lock( 0, 0, (VOID**)&pVertices, 0 ) ) )
        return DXTRACE_ERR( "Lock", hr );

	int i;

	CUSTOMVERTEX* vertex;

	vertex = pVertices;

	float theta;
	float phi;
	float rho;
	float x, y, z;
	unsigned int   iAQuantize;
	float          fAQuantize;
	unsigned int   iBQuantize;
	float          fBQuantize;
	unsigned int   iCQuantize;
	float          fCQuantize;

	iAQuantize = 200;
	fAQuantize = (float)(iAQuantize-1);
	iBQuantize = 50;
	fBQuantize = (float)(iBQuantize-1);
	iCQuantize = 60;
	fCQuantize = (float)(iCQuantize-1);

	regular;
	method;

	// method 3 is not phi & theta -based, so handle seperately.
	if (method == OXE_SPHMAP_3 || method == OXE_SPHMAP_4)
		{
		for (i = 0; i < num; i++)
			{
			// choose a random point on the surface of the unit cube:
			if (regular)
			{
				x = (float)(rand() % iCQuantize) / (float)fCQuantize;
				y = (float)(rand() % iCQuantize) / (float)fCQuantize;
				z = (float)(rand() % iCQuantize) / (float)fCQuantize;
			}
			else
			{
				x = ((float)rand()) / (float)RAND_MAX;
				y = ((float)rand()) / (float)RAND_MAX;
				z = ((float)rand()) / (float)RAND_MAX;
			}

			// x y and z now between 0 and 1

			x = x * 2.0f - 1.0f;
			y = y * 2.0f - 1.0f;
			z = z * 2.0f - 1.0f;

			// choose which face of the cube to put dem on.
			switch (rand() % 6)
				{
				case 0:
					x = -1.0f;
					vertex->normal   = D3DXVECTOR3(x, 0, 0);
					break;
				case 1:
					x =  1.0f;
					vertex->normal   = D3DXVECTOR3(x, 0, 0);
					break;
				case 2:
					y = -1.0f;
					vertex->normal   = D3DXVECTOR3(0, y, 0);
					break;
				case 3:
					y =  1.0f;
					vertex->normal   = D3DXVECTOR3(0, y, 0);
					break;
				case 4:
					z = -1.0f;
					vertex->normal   = D3DXVECTOR3(0, 0, z);
					break;
				case 5:
					z =  1.0f;
					vertex->normal   = D3DXVECTOR3(0, 0, z);
					break;
				}

			if (method == OXE_SPHMAP_3)
			{
				// normalize to sphere
				float f = 1.0f/(sqrtf(x*x + y*y + z*z));
				x *= f;
				y *= f;
				z *= f;
				vertex->normal   = D3DXVECTOR3(x  , y  ,   z);
			}

			vertex->position = D3DXVECTOR3(r*x, r*y, r*z);

			vertex++;
			}
		}
	else
		{
		for (i = 0; i < num; i++)
			{
			// choose a theta & rho
			if (regular)
			{
				theta = ((float)(rand() % iAQuantize)) / fAQuantize;
				rho   = ((float)(rand() % iBQuantize)) / fBQuantize;
			}
			else
			{
				theta = ((float)rand()) / (float)RAND_MAX;
				rho   = ((float)rand()) / (float)RAND_MAX;
			}

			// theta and rho now between 0 and 1

			theta *= 2.0f * 3.14159265359f;
			rho   *= 2.0f;


			// convert rho to phi;
			switch(method)
				{
				default:
				case OXE_SPHMAP_1:
					phi   = rho        * 3.14159265359f * 0.5f;
					break;
				case OXE_SPHMAP_2:
					if (rho < 1.0f)
						phi   = sqrtf(rho) * 3.14159265359f * 0.5f;
					else
						phi   = (2.0f - sqrtf(2.0f - rho)) * 3.14159265359f * 0.5f;
					break;
				}


			// spherical to cartesian
			x = sinf(phi) * cosf(theta);
			y = cosf(phi);
			z = sinf(phi) * sinf(theta);


			vertex->normal   = D3DXVECTOR3(x  , y  ,   z);
			vertex->position = D3DXVECTOR3(r*x, r*y, r*z);

			vertex++;
			}
		}


    vb->Unlock();

    return S_OK;
	}

HRESULT CAppForm::oxe_RandomDiskPoints(LPDIRECT3DVERTEXBUFFER9& vb, int num, float r, int method, bool regular)
	{
    HRESULT hr;

    SAFE_RELEASE( vb );

    // Create the vertex buffer
    if( FAILED( hr = m_pd3dDevice->CreateVertexBuffer( num*sizeof(CUSTOMVERTEX),
                                                  0, D3DFVF_CUSTOMVERTEX,
                                                  D3DPOOL_MANAGED, &vb, NULL ) ) )
        return DXTRACE_ERR( "CreateVertexBuffer", hr );

    CUSTOMVERTEX* pVertices;

    if( FAILED( hr = vb->Lock( 0, 0, (VOID**)&pVertices, 0 ) ) )
        return DXTRACE_ERR( "Lock", hr );

	int i;

	CUSTOMVERTEX* vertex;

	vertex = pVertices;

	float theta;
	float rho;
	float rad;
	float x, y, z;
	int   iAQuantize;
	float fAQuantize;
	int   iBQuantize;
	float fBQuantize;

	iAQuantize = 200;
	fAQuantize = (float)iAQuantize;
	iBQuantize = 50;
	fBQuantize = (float)iBQuantize;

	for (i = 0; i < num; i++)
		{

		if (regular)
		{
			theta = ((float)(rand() % iAQuantize)) / fAQuantize;
			rho   = ((float)(rand() % iBQuantize)) / fBQuantize;
		}
		else
		{
			theta = ((float)rand()) / (float)RAND_MAX;
			rho   = ((float)rand()) / (float)RAND_MAX;
		}


		// theta and rho now between 0 and 1
		theta *= 2.0f * 3.14159265359f;

		// convert rho to phi;
		switch(method)
			{
			default:
			case OXE_SPHMAP_1:
				rad   = rho;
				break;
			case OXE_SPHMAP_2:
				rad   = sqrtf(rho);
				break;
			}

		rad *= r;

		// polar to cartesian
		x = rad * cosf(theta);
		y = rad * sinf(theta);
		z = 0.0f;



		vertex->position = D3DXVECTOR3(x, y, z);
		vertex->normal   = D3DXVECTOR3(0.0f, 0.0f, -1.0f);

		vertex++;
		}


    vb->Unlock();

    return S_OK;
	}

HRESULT CAppForm::oxe_Axes(LPDIRECT3DVERTEXBUFFER9& vb, float r)
	{
    HRESULT hr;

    SAFE_RELEASE( vb );

    // Create the vertex buffer
    if( FAILED( hr = m_pd3dDevice->CreateVertexBuffer( 6 * sizeof(CUSTOMVERTEX),
                                                  0, D3DFVF_CUSTOMVERTEX,
                                                  D3DPOOL_MANAGED, &vb, NULL ) ) )
        return DXTRACE_ERR( "CreateVertexBuffer", hr );

    CUSTOMVERTEX* pVertices;

    if( FAILED( hr = vb->Lock( 0, 0, (VOID**)&pVertices, 0 ) ) )
        return DXTRACE_ERR( "Lock", hr );

	pVertices[0].position = D3DXVECTOR3(-r,  0,  0);
	pVertices[1].position = D3DXVECTOR3( r,  0,  0);
	pVertices[2].position = D3DXVECTOR3( 0, -r,  0);
	pVertices[3].position = D3DXVECTOR3( 0,  r,  0);
	pVertices[4].position = D3DXVECTOR3( 0,  0, -r);
	pVertices[5].position = D3DXVECTOR3( 0,  0,  r);


    vb->Unlock();

    return S_OK;
	}

HRESULT CAppForm::InitDeviceObjects()
{
    // TODO: create device objects

    HRESULT hr;

    // Init the font
    m_pFont->InitDeviceObjects( m_pd3dDevice );

	m_gui_Edit1 .SetWindowText("10000");
	m_gui_Check2.SetCheck(1);

	OnButton1();

    // Create the vertex buffer
    if( FAILED( hr = m_pd3dDevice->CreateVertexBuffer( 3*2*sizeof(CUSTOMVERTEX),
                                                  0, D3DFVF_CUSTOMVERTEX,
                                                  D3DPOOL_MANAGED, &m_pVB, NULL ) ) )
        return DXTRACE_ERR( "CreateVertexBuffer", hr );

    // Fill the vertex buffer with 2 triangles
    CUSTOMVERTEX* pVertices;

    if( FAILED( hr = m_pVB->Lock( 0, 0, (VOID**)&pVertices, 0 ) ) )
        return DXTRACE_ERR( "Lock", hr );

    // Front triangle`
    pVertices[0].position = D3DXVECTOR3( -1.0f, -1.0f,  0.0f );
    pVertices[0].normal   = D3DXVECTOR3(  0.0f,  0.0f, -1.0f );
    pVertices[1].position = D3DXVECTOR3(  0.0f,  1.0f,  0.0f );
    pVertices[1].normal   = D3DXVECTOR3(  0.0f,  0.0f, -1.0f );
    pVertices[2].position = D3DXVECTOR3(  1.0f, -1.0f,  0.0f );
    pVertices[2].normal   = D3DXVECTOR3(  0.0f,  0.0f, -1.0f );

    // Back triangle
    pVertices[3].position = D3DXVECTOR3( -1.0f, -1.0f,  0.0f );
    pVertices[3].normal   = D3DXVECTOR3(  0.0f,  0.0f,  1.0f );
    pVertices[4].position = D3DXVECTOR3(  1.0f, -1.0f,  0.0f );
    pVertices[4].normal   = D3DXVECTOR3(  0.0f,  0.0f,  1.0f );
    pVertices[5].position = D3DXVECTOR3(  0.0f,  1.0f,  0.0f );
    pVertices[5].normal   = D3DXVECTOR3(  0.0f,  0.0f,  1.0f );

    m_pVB->Unlock();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::RestoreDeviceObjects()
// Desc: Paired with InvalidateDeviceObjects()
//       The device exists, but may have just been Reset().  Resources in
//       D3DPOOL_DEFAULT and any other device state that persists during
//       rendering should be set here.  Render states, matrices, textures,
//       etc., that don't change during rendering can be set once here to
//       avoid redundant state setting during Render() or FrameMove().
//-----------------------------------------------------------------------------
HRESULT CAppForm::RestoreDeviceObjects()
{
    // TODO: setup render states

    // Setup a material
    D3DMATERIAL9 mtrl;
    D3DUtil_InitMaterial( mtrl, 1.0f, 1.0f, 1.0f );
    m_pd3dDevice->SetMaterial( &mtrl );

    // Set up the textures
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
    m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
    m_pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
    m_pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

    // Set miscellaneous render states
    m_pd3dDevice->SetRenderState( D3DRS_DITHERENABLE,   FALSE );
    m_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
    m_pd3dDevice->SetRenderState( D3DRS_ZENABLE,        TRUE );
	float PointSize = 1.0f;
    m_pd3dDevice->SetRenderState( D3DRS_POINTSIZE,      *((DWORD*)&PointSize));
    m_pd3dDevice->SetRenderState( D3DRS_AMBIENT,        0x000F0F0F );

    // Set the world matrix
    D3DXMATRIX matIdentity;
    D3DXMatrixIdentity( &matIdentity );
    m_pd3dDevice->SetTransform( D3DTS_WORLD,  &matIdentity );

    // Set up our view matrix. A view matrix can be defined given an eye point,
    // a point to lookat, and a direction for which way is up. Here, we set the
    // eye five units back along the z-axis and up three units, look at the
    // origin, and define "up" to be in the y-direction.
    D3DXMATRIX matView;
    D3DXVECTOR3 vFromPt   = D3DXVECTOR3( 0.0f, 0.0f, -5.0f );
    D3DXVECTOR3 vLookatPt = D3DXVECTOR3( 0.0f, 0.0f, 0.0f );
    D3DXVECTOR3 vUpVec    = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
    D3DXMatrixLookAtLH( &matView, &vFromPt, &vLookatPt, &vUpVec );
    m_pd3dDevice->SetTransform( D3DTS_VIEW, &matView );

    // Set the projection matrix
    D3DXMATRIX matProj;
    FLOAT fAspect = ((FLOAT)m_d3dsdBackBuffer.Width) / m_d3dsdBackBuffer.Height;
    D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, fAspect, 1.0f, 100.0f );
    m_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );

    // Set up lighting states
    D3DLIGHT9 light;
    D3DUtil_InitLight(light, D3DLIGHT_DIRECTIONAL, -1.0f, -1.0f, 2.0f );
    m_pd3dDevice->SetLight( 0, &light );
    m_pd3dDevice->LightEnable( 0, TRUE );
    m_pd3dDevice->SetRenderState( D3DRS_LIGHTING, TRUE );

    // Restore the font
    m_pFont->RestoreDeviceObjects();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::FrameMove()
// Desc: Called once per frame, the call is the entry point for animating
//       the scene.
//-----------------------------------------------------------------------------
HRESULT CAppForm::FrameMove()
{
    // TODO: update world

    // Update user input state
    UpdateInput( &m_UserInput );

    // Update the world state according to user input
    D3DXMATRIX matWorld;
    D3DXMATRIX matRotY;
    D3DXMATRIX matRotX;

    if( m_UserInput.bRotateLeft && !m_UserInput.bRotateRight)
        m_fWorldRotY += m_fElapsedTime;
    else if( m_UserInput.bRotateRight && !m_UserInput.bRotateLeft )
        m_fWorldRotY -= m_fElapsedTime;

    if( m_UserInput.bRotateUp && !m_UserInput.bRotateDown )
        m_fWorldRotX += m_fElapsedTime;
    else if( m_UserInput.bRotateDown && !m_UserInput.bRotateUp )
        m_fWorldRotX -= m_fElapsedTime;

	if (m_gui_Check3.GetCheck() & 3)
	{
        m_fWorldRotY += m_fElapsedTime * 0.1f;
	}
	if (m_gui_Check4.GetCheck() & 3)
	{
        m_fWorldRotX += m_fElapsedTime * 0.1f;
	}

    D3DXMatrixRotationX( &matRotX, m_fWorldRotX );
    D3DXMatrixRotationY( &matRotY, m_fWorldRotY );

    D3DXMatrixMultiply( &matWorld, &matRotX, &matRotY );
    m_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: UpdateInput()
// Desc: Update the user input.  Called once per frame 
//-----------------------------------------------------------------------------
void CAppForm::UpdateInput( UserInput* pUserInput )
{
    HRESULT hr;

    // Get the input's device state, and put the state in dims
    ZeroMemory( &pUserInput->diks, sizeof(pUserInput->diks) );
    hr = m_pKeyboard->GetDeviceState( sizeof(pUserInput->diks), &pUserInput->diks );
    if( FAILED(hr) ) 
    {
        m_pKeyboard->Acquire();
        return; 
    }

    // TODO: Process user input as needed
    pUserInput->bRotateLeft  = ( (pUserInput->diks[DIK_LEFT] & 0x80)  == 0x80 );
    pUserInput->bRotateRight = ( (pUserInput->diks[DIK_RIGHT] & 0x80) == 0x80 );
    pUserInput->bRotateUp    = ( (pUserInput->diks[DIK_UP] & 0x80)    == 0x80 );
    pUserInput->bRotateDown  = ( (pUserInput->diks[DIK_DOWN] & 0x80)  == 0x80 );
}




//-----------------------------------------------------------------------------
// Name: CAppForm::Render()
// Desc: Called once per frame, the call is the entry point for 3d
//       rendering. This function sets up render states, clears the
//       viewport, and renders the scene.
//-----------------------------------------------------------------------------
HRESULT CAppForm::Render()
{
    // Clear the viewport
    m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
                         0x00010101, 1.0f, 0L );

	float pointSize;

	if (m_gui_Check5.GetCheck() & 3)
		pointSize = 3.0f;
	else
		pointSize = 1.0f;


    // Begin the scene
    if( SUCCEEDED( m_pd3dDevice->BeginScene() ) )
    {
        // TODO: render world
        
        // Render the vertex buffer contents
	    m_pd3dDevice->SetRenderState( D3DRS_AMBIENT  ,        0x00800000 );
	    m_pd3dDevice->SetRenderState( D3DRS_POINTSIZE,        *((DWORD*)&pointSize));
        m_pd3dDevice->SetStreamSource( 0, m_pVB2, 0, sizeof(CUSTOMVERTEX) );
        m_pd3dDevice->SetFVF( D3DFVF_CUSTOMVERTEX );
		m_pd3dDevice->DrawPrimitive( D3DPT_POINTLIST, 0, m_VB2Num);



		if (m_gui_Check2.GetCheck() & 3)
		{
			// axes
			m_pd3dDevice->SetRenderState( D3DRS_AMBIENT,        0x00000000 );
			m_pd3dDevice->SetStreamSource( 0, m_pVB3, 0, sizeof(CUSTOMVERTEX) );
			m_pd3dDevice->SetFVF( D3DFVF_CUSTOMVERTEX );
			m_pd3dDevice->SetRenderState( D3DRS_AMBIENT,        0x00FF0000 );
			m_pd3dDevice->DrawPrimitive( D3DPT_LINELIST, 0, 1);
			m_pd3dDevice->SetRenderState( D3DRS_AMBIENT,        0x0000FF00 );
			m_pd3dDevice->DrawPrimitive( D3DPT_LINELIST, 2, 1);
			m_pd3dDevice->SetRenderState( D3DRS_AMBIENT,        0x000000FF );
			m_pd3dDevice->DrawPrimitive( D3DPT_LINELIST, 4, 1);
		}
		
        // Render stats and help text  
//        RenderText();

        // End the scene.
        m_pd3dDevice->EndScene();
    }

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: RenderText()
// Desc: Renders stats and help text to the scene.
//-----------------------------------------------------------------------------
HRESULT CAppForm::RenderText()
{
    D3DCOLOR fontColor        = D3DCOLOR_ARGB(255,255,255,0);
    TCHAR szMsg[MAX_PATH] = TEXT("");

    // Output display stats
    FLOAT fNextLine = 40.0f; 

    lstrcpy( szMsg, m_strDeviceStats );
    fNextLine -= 20.0f;
    m_pFont->DrawText( 2, fNextLine, fontColor, szMsg );

    lstrcpy( szMsg, m_strFrameStats );
    fNextLine -= 20.0f;
    m_pFont->DrawText( 2, fNextLine, fontColor, szMsg );

    // Output statistics & help
    fNextLine = (FLOAT) m_d3dsdBackBuffer.Height; 

    wsprintf( szMsg, TEXT("Arrow keys: Up=%d Down=%d Left=%d Right=%d"), 
              m_UserInput.bRotateUp, m_UserInput.bRotateDown, m_UserInput.bRotateLeft, m_UserInput.bRotateRight );
    fNextLine -= 20.0f; m_pFont->DrawText( 2, fNextLine, fontColor, szMsg );

    lstrcpy( szMsg, TEXT("Use arrow keys to rotate object") );
    fNextLine -= 20.0f; m_pFont->DrawText( 2, fNextLine, fontColor, szMsg );

    lstrcpy( szMsg, TEXT("Press 'F2' to configure display") );
    fNextLine -= 20.0f; m_pFont->DrawText( 2, fNextLine, fontColor, szMsg );

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: DoDataExchange()
// Desc: DDX/DDV support
//-----------------------------------------------------------------------------
void CAppForm::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAppForm)
	DDX_Control(pDX, IDC_CHECK5, m_gui_Check5);
	DDX_Control(pDX, IDC_CHECK4, m_gui_Check4);
	DDX_Control(pDX, IDC_CHECK3, m_gui_Check3);
	DDX_Control(pDX, IDC_CHECK2, m_gui_Check2);
	DDX_Control(pDX, IDC_CHECK1, m_gui_Check_Regular);
	DDX_Control(pDX, IDC_EDIT1, m_gui_Edit1);
	//}}AFX_DATA_MAP
}




//-----------------------------------------------------------------------------
// Name: WindowProc()
// Desc: 
//-----------------------------------------------------------------------------
LRESULT CAppForm::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
    return CFormView ::WindowProc(message, wParam, lParam);
}




//-----------------------------------------------------------------------------
// Name: OnChangeDevice()
// Desc: Needed to enable dlg menu item 
//-----------------------------------------------------------------------------
void CAppFrameWnd::OnChangeDevice() 
{
    g_AppFormView->OnChangeDevice();
}




//-----------------------------------------------------------------------------
// Name: CAppForm::InvalidateDeviceObjects()
// Desc: Invalidates device objects.  Paired with RestoreDeviceObjects()
//-----------------------------------------------------------------------------
HRESULT CAppForm::InvalidateDeviceObjects()
{
    // TODO: Cleanup any objects created in RestoreDeviceObjects()
    m_pFont->InvalidateDeviceObjects();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::DeleteDeviceObjects()
// Desc: Paired with InitDeviceObjects()
//       Called when the app is exiting, or the device is being changed,
//       this function deletes any device dependent objects.  
//-----------------------------------------------------------------------------
HRESULT CAppForm::DeleteDeviceObjects()
{
    // TODO: Cleanup any objects created in InitDeviceObjects()
    m_pFont->DeleteDeviceObjects();
    SAFE_RELEASE( m_pVB  );
    SAFE_RELEASE( m_pVB2 );
    SAFE_RELEASE( m_pVB3 );

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CAppForm::FinalCleanup()
// Desc: Paired with OneTimeSceneInit()
//       Called before the app exits, this function gives the app the chance
//       to cleanup after itself.
//-----------------------------------------------------------------------------
HRESULT CAppForm::FinalCleanup()
{
    // TODO: Perform any final cleanup needed
    // Cleanup D3D font
    SAFE_DELETE( m_pFont );

    // Cleanup DirectInput
    CleanupDirectInput();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CleanupDirectInput()
// Desc: Cleanup DirectInput 
//-----------------------------------------------------------------------------
VOID CAppForm::CleanupDirectInput()
{
    // Cleanup DirectX input objects
    SAFE_RELEASE( m_pKeyboard );
    SAFE_RELEASE( m_pDI );

}




//-----------------------------------------------------------------------------
// Name: InitInstance()
// Desc: This is the main entry point for the application. The MFC window stuff
//       is initialized here. See also the main initialization routine for the
//       CAppForm class, which is called indirectly from here.
//-----------------------------------------------------------------------------
BOOL CApp::InitInstance()
{
    // Asscociate the MFC app with the frame window and doc/view classes
    AddDocTemplate( new CSingleDocTemplate( IDR_MAINFRAME,
                                            RUNTIME_CLASS(CAppDoc),
                                            RUNTIME_CLASS(CAppFrameWnd),
                                            RUNTIME_CLASS(CAppForm) ) );

    // Dispatch commands specified on the command line (req'd by MFC). This
    // also initializes the the CAppDoc, CAppFrameWnd, and CAppForm classes.
    CCommandLineInfo cmdInfo;
    ParseCommandLine( cmdInfo );
    if( !ProcessShellCommand( cmdInfo ) )
        return FALSE;

    if( !g_AppFormView->IsReady() )
        return FALSE;

    g_AppFormView->GetParentFrame()->RecalcLayout();
    g_AppFormView->ResizeParentToFit( FALSE ); 
    
    m_pMainWnd->SetWindowText( g_strAppTitle );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}




//-----------------------------------------------------------------------------
// Name: LoadFrame()
// Desc: Uses idle time to render the 3D scene.
//-----------------------------------------------------------------------------
BOOL CAppFrameWnd::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
    BOOL bResult = CFrameWnd::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext);
    
    LoadAccelTable( MAKEINTRESOURCE(IDR_MAIN_ACCEL) );

    return bResult;
}




//-----------------------------------------------------------------------------
// Name: OnIdle()
// Desc: Uses idle time to render the 3D scene.
//-----------------------------------------------------------------------------
BOOL CApp::OnIdle( LONG )
{
    // Do not render if the app is minimized
    if( m_pMainWnd->IsIconic() )
        return FALSE;

    TCHAR strStatsPrev[200];

    lstrcpy(strStatsPrev, g_AppFormView->PstrFrameStats());

    // Update and render a frame
    if( g_AppFormView->IsReady() )
    {
        g_AppFormView->CheckForLostFullscreen();
        g_AppFormView->RenderScene();
    }

	Sleep(10);

    // Keep requesting more idle time
    return TRUE;
}




//-----------------------------------------------------------------------------
// Name: PreCreateWindow()
// Desc: Change the window style (so it cannot maximize or be sized) before
//       the main frame window is created.
//-----------------------------------------------------------------------------
BOOL CAppFrameWnd::PreCreateWindow( CREATESTRUCT& cs )
{
    cs.style = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX;

    return CFrameWnd::PreCreateWindow( cs );
}




//-----------------------------------------------------------------------------
// Name: ~CAppForm()
// Desc: Destructor for the dialog resource form. Shuts down the app
//-----------------------------------------------------------------------------
CAppForm::~CAppForm()
{
    Cleanup3DEnvironment();
    SAFE_RELEASE( m_pD3D );
    FinalCleanup();
}




//-----------------------------------------------------------------------------
// Name: OnToggleFullScreen()
// Desc: Called when user toggles the fullscreen mode
//-----------------------------------------------------------------------------
void CAppForm::OnToggleFullScreen()
{
    ToggleFullscreen();
}




//-----------------------------------------------------------------------------
// Name: OnChangeDevice()
// Desc: Use hit the "Change Device.." button. Display the dialog for the user
//       to select a new device/mode, and call Change3DEnvironment to
//       use the new device/mode.
//-----------------------------------------------------------------------------
VOID CAppForm::OnChangeDevice()
{
    Pause(true);

    UserSelectNewDevice();

    // Update UI
    UpdateUIForDeviceCapabilites();

    Pause(false);
}




//-----------------------------------------------------------------------------
// Name: AdjustWindowForChange()
// Desc: Adjusts the window properties for windowed or fullscreen mode
//-----------------------------------------------------------------------------
HRESULT CAppForm::AdjustWindowForChange()
{
    if( m_bWindowed )
    {
        ::ShowWindow( m_hwndRenderFullScreen, SW_HIDE );
        CD3DApplication::m_hWnd = m_hwndRenderWindow;

        // Tell the action mapper that the focus wnd has changed
        m_pKeyboard->SetCooperativeLevel( m_hWndTopLevelParent, 
                                                DISCL_NONEXCLUSIVE | 
                                                DISCL_FOREGROUND | 
                                                DISCL_NOWINKEY );
    }
    else
    {
        if( ::IsIconic( m_hwndRenderFullScreen ) )
            ::ShowWindow( m_hwndRenderFullScreen, SW_RESTORE );
        ::ShowWindow( m_hwndRenderFullScreen, SW_SHOW );
        CD3DApplication::m_hWnd = m_hwndRenderFullScreen;

        // Tell the action mapper that the focus wnd has changed
        m_pKeyboard->SetCooperativeLevel( m_hwndRenderFullScreen, 
                                                DISCL_NONEXCLUSIVE | 
                                                DISCL_FOREGROUND | 
                                                DISCL_NOWINKEY );
    }

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: FullScreenWndProc()
// Desc: The WndProc funtion used when the app is in fullscreen mode. This is
//       needed simply to trap the ESC key.
//-----------------------------------------------------------------------------
LRESULT CALLBACK FullScreenWndProc( HWND hWnd, UINT msg, WPARAM wParam,
                                    LPARAM lParam )
{
    if( msg == WM_CLOSE )
    {
        // User wants to exit, so go back to windowed mode and exit for real
        g_AppFormView->OnToggleFullScreen();
        g_App.GetMainWnd()->PostMessage( WM_CLOSE, 0, 0 );
    }
    else if( msg == WM_SETCURSOR )
    {
        SetCursor( NULL );
    }
    else if( msg == WM_KEYUP && wParam == VK_ESCAPE )
    {
        // User wants to leave fullscreen mode
        g_AppFormView->OnToggleFullScreen();
    }

    return DefWindowProc( hWnd, msg, wParam, lParam );
}




//-----------------------------------------------------------------------------
// Name: CheckForLostFullscreen()
// Desc: If fullscreen and device was lost (probably due to alt-tab), 
//       automatically switch to windowed mode
//-----------------------------------------------------------------------------
HRESULT CAppForm::CheckForLostFullscreen()
{
    HRESULT hr;

    if( m_bWindowed )
        return S_OK;

    if( FAILED( hr = m_pd3dDevice->TestCooperativeLevel() ) )
        ForceWindowed();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: UpdateUIForDeviceCapabilites()
// Desc: Whenever we get a new device, call this function to enable/disable the
//       appropiate UI controls to match the device's capabilities.
//-----------------------------------------------------------------------------
VOID CAppForm::UpdateUIForDeviceCapabilites()
{
    // TODO: Check the capabilities of the device and update the UI as needed
    DWORD dwCaps = m_d3dCaps.RasterCaps;
    UNREFERENCED_PARAMETER( dwCaps );
}




//-----------------------------------------------------------------------------
// Name: OnInitialUpdate()
// Desc: When the AppForm object is created, this function is called to
//       initialize it. Here we getting access ptrs to some of the controls,
//       and setting the initial state of some of them as well.
//-----------------------------------------------------------------------------
VOID CAppForm::OnInitialUpdate()
{
    // Update the UI
    CFormView::OnInitialUpdate();

    // Get the top level parent hwnd
    m_hWndTopLevelParent = GetTopLevelParent()->GetSafeHwnd();

    // Save static reference to the render window
    m_hwndRenderWindow = GetDlgItem(IDC_RENDERVIEW)->GetSafeHwnd();

    // Register a class for a fullscreen window
    WNDCLASS wndClass = { CS_HREDRAW | CS_VREDRAW, FullScreenWndProc, 0, 0, NULL,
                          NULL, NULL, (HBRUSH)GetStockObject(WHITE_BRUSH), NULL,
                          _T("Fullscreen Window") };
    RegisterClass( &wndClass );

    // We create the fullscreen window (not visible) at startup, so it can
    // be the focus window.  The focus window can only be set at CreateDevice
    // time, not in a Reset, so ToggleFullscreen wouldn't work unless we have
    // already set up the fullscreen focus window.
    m_hwndRenderFullScreen = CreateWindow( _T("Fullscreen Window"), NULL,
                                           WS_POPUP, CW_USEDEFAULT,
                                           CW_USEDEFAULT, 100, 100,
                                           m_hWndTopLevelParent, 0L, NULL, 0L );

    // Note that for the MFC samples, the device window and focus window
    // are not the same.
    CD3DApplication::m_hWnd = m_hwndRenderWindow;
    CD3DApplication::m_hWndFocus = m_hwndRenderFullScreen;
    CD3DApplication::Create( AfxGetInstanceHandle() );

    // TODO: Update the UI as needed
}



static int getNumVertices(CWnd& wnd, int max)
{
	CString cs;
	int num;
	wnd.GetWindowText(cs);
	num = atoi(cs);
	if (num > max)
	{
		char s[32];
		sprintf(s, "%d", max);
		wnd.SetWindowText(s);
		num = max;
	}

	return num;
}




void CAppForm::OnButton1() 
{
	m_VB2Num = getNumVertices(m_gui_Edit1, 65535);

	oxe_RandomDiskPoints(m_pVB2, m_VB2Num, 1.5f, OXE_SPHMAP_1, m_gui_Check_Regular.GetCheck() & 3);
	oxe_Axes              (m_pVB3, 1.9f);
}

void CAppForm::OnButton2() 
{
	m_VB2Num = getNumVertices(m_gui_Edit1, 65535);
	
	oxe_RandomDiskPoints(m_pVB2, m_VB2Num, 1.5f, OXE_SPHMAP_2, m_gui_Check_Regular.GetCheck() & 3);
	oxe_Axes              (m_pVB3, 1.9f);
}

BOOL CAppForm::OnInitDialog() 
{
//	CFormView ::OnInitDialog();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAppForm::OnButton3() 
{
	m_VB2Num = getNumVertices(m_gui_Edit1, 65535);

	oxe_RandomSpherePoints(m_pVB2, m_VB2Num, 1.5f, OXE_SPHMAP_1, m_gui_Check_Regular.GetCheck() & 3);
	oxe_Axes              (m_pVB3, 1.9f);
}

void CAppForm::OnButton4() 
{
	m_VB2Num = getNumVertices(m_gui_Edit1, 65535);

	oxe_RandomSpherePoints(m_pVB2, m_VB2Num, 1.5f, OXE_SPHMAP_2, m_gui_Check_Regular.GetCheck() & 3);
	oxe_Axes              (m_pVB3, 1.9f);
}

void CAppForm::OnButton6() 
{
	m_VB2Num = getNumVertices(m_gui_Edit1, 65535);

	oxe_RandomSpherePoints(m_pVB2, m_VB2Num, 1.5f, OXE_SPHMAP_3, m_gui_Check_Regular.GetCheck() & 3);
	oxe_Axes              (m_pVB3, 1.9f);
}


void CAppForm::OnButton7() 
{
	m_VB2Num = getNumVertices(m_gui_Edit1, 65535);

	oxe_RandomSpherePoints(m_pVB2, m_VB2Num, 1.0f, OXE_SPHMAP_4, m_gui_Check_Regular.GetCheck() & 3);
	oxe_Axes              (m_pVB3, 1.9f);
}


#include "GollyDlg.h"
CDialog* g_GollyDlg = NULL;

void CAppForm::OnButton5() 
{
	if (!g_GollyDlg)
		{
		g_GollyDlg = new GollyDlg(this);
		g_GollyDlg ->Create(IDD_DIALOG1, this);
		}

	g_GollyDlg -> ShowWindow(true);
}





